# Noderr Protocol - White Papers

Official White Papers for the Noderr Protocol.

## Current Version

### [Noderr White Paper v7.1](Noderr_White_Paper_v7.1.md)
**Comprehensive technical specification** (375,504 words, 32,139 lines)

**Date**: November 23, 2025  
**Status**: Live Testnet Deployment (Base Sepolia)  
**Audit Status**: ✅ PhD-Level Audit Complete

**Key Updates from v7.0**:
- ✅ APY figures corrected (8-15% → 8-28% combining vault + node operation)
- ✅ Node operation rewards updated to conservative estimates
- ✅ Contract addresses verified on Base Sepolia (17 contracts)
- ✅ Deployment appendix added with actual testnet addresses
- ✅ Clarification notes added for governance parameters

### [Noderr Lite Paper v3.1](Noderr_Lite_Paper_v3.1.md)
**Investor-focused summary** (14,294 words, ~40 pages)

**Date**: November 23, 2025  
**Target Audience**: Institutional investors, venture capital firms, DAO treasuries

**Contents**:
- Executive Summary & Investment Thesis
- Problem Statement & Market Analysis
- Solution Architecture
- Technical Implementation
- Economic Model & Tokenomics
- Node Operator Framework
- Governance Structure
- Risk Management & Security
- Roadmap & Development
- Competitive Analysis
- Investment Opportunity

## Version History

See [VERSION_HISTORY.md](VERSION_HISTORY.md) for complete changelog.

## Archive

Previous versions are archived in the [archive/](archive/) directory:
- [v7.0](archive/v7.0/) - October 19, 2025

## Audit Reports

Comprehensive audit reports for v7.1 are available in the [../audit-reports/v7.1/](../audit-reports/v7.1/) directory:
- FINAL-PHD-LEVEL-AUDIT-SUMMARY.md
- whitepaper-audit-findings.md
- ate-floor-engine-audit.md

## Key Metrics (v7.1)

**Performance Targets** (non-guaranteed):
- **Target APY**: 8-28% (vault investment 5-28% + node operation 5-25%)
- **Floor Engine Baseline**: 5-8% APY
- **Risk-Adjusted Returns**: Sharpe Ratio ≥1.5 (governance guideline)

**Node Operation Rewards**:
- **Micro Nodes**: 5-10% APY (0 NODR stake)
- **Validators**: 10-15% APY + fees (50,000 NODR stake)
- **Guardians**: 15-20% APY + stipend + 5% profit (100,000 NODR stake)
- **Oracles**: 20-25% APY + stipend + 10% profit (500,000 NODR stake)

**Deployment Status**:
- **Network**: Base Sepolia (Chain ID: 84532)
- **Smart Contracts**: 17 deployed and verified
- **dApp**: https://noderr-dapp-production.up.railway.app
- **Website**: https://noderr.xyz

## License

**License**: Proprietary - All Rights Reserved  
**Copyright**: © 2025 Noderr Protocol

---

**Last Updated**: November 23, 2025  
**Current Version**: 7.1  
**Maintained By**: Noderr Protocol Team
